
import numpy as np
from skimage.transform import pyramid_gaussian
from imutils.object_detection import non_max_suppression
import imutils
from skimage.feature import hog
from sklearn.externals import joblib
import cv2
from config import *
from skimage import color
import matplotlib.pyplot as plt
 
def sliding_window(image, window_size, step_size):
    for y in xrange(0, image.shape[0], step_size[1]):
        for x in xrange(0, image.shape[1], step_size[0]):
            yield (x, y, image[y:y + window_size[1], x:x + window_size[0]])


def detector(filename):
    counter = 0
    im=cv2.imread(filename)
##    im = imutils.resize(im, width=min(200, im.shape[1]))
    min_wdw_sz = (96,96)
    step_size = (12,12) 
    downscale = 1.1
    visualize_det = 1

    clf = joblib.load(model_path)

    detections = []

    scale = 0
    im_scaled=im

    cd = []
    for (x, y, im_window) in sliding_window(im_scaled, min_wdw_sz, step_size):
        if im_window.shape[0] != min_wdw_sz[1] or im_window.shape[1] != min_wdw_sz[0]:
            continue

        im_window=color.rgb2gray(im_window)
        fd = hog(im_window, orientations, pixels_per_cell, cells_per_block, visualize, normalize)

        fd=fd.reshape(1,-1)
        pred = clf.predict(fd)
        if pred == 1:
            if clf.decision_function(fd)>0.5:
                detections.append((x, y, clf.decision_function(fd),
                    int(min_wdw_sz[0]),
                    int(min_wdw_sz[1])))
                cd.append(detections[-1])
            
        if visualize_det:
            clone = im_scaled.copy()
            for x1, y1, _, _, _  in cd:
                cv2.circle(clone,(x1 + (im_window.shape[1]/2), y1 +
                    (im_window.shape[0]/2)),1,(0, 255, 255),thickness=2)
            cv2.rectangle(clone, (x, y), (x + im_window.shape[1], y +
                im_window.shape[0]), (0, 255, 0), thickness=3)
            cv2.imshow("Sliding Window in Progress", clone)
            cv2.waitKey(1)
    scale=0


    clone = im.copy()
    
    for (x_tl, y_tl, _, w, h) in detections:
        cv2.rectangle(im, (x_tl, y_tl), (x_tl+w, y_tl+h), (255, 0, 255), thickness=2)
    
    rects = np.array([[x, y, x + w, y + h] for (x, y,_, w, h) in detections])
    pick = non_max_suppression(rects, probs=None, overlapThresh=0.1)
    
    for (xA, yA, xB, yB) in pick:
        cv2.rectangle(clone, (xA, yA), (xB, yB), (0, 255,0), 3)
        counter +=1

    print "counter = %d" %counter

    cv2.imshow("Raw Detections before NMS",im)
    cv2.imshow("Final Detections",clone)
    

    cv2.waitKey(0)
    cv2.destroyAllWindows()

from os.path import join
import glob
        
        
if __name__ == "__main__":
    detector("Train2.jpg")

