from skimage.feature import hog
from skimage.io import imread
from sklearn.externals import joblib
import glob
import os
from config import *
import numpy as np

import matplotlib.pyplot as plt
import cv2
import math
from scipy.spatial import distance
from skimage import data, color, exposure
from scipy import ndimage
import scipy

    
def extract_features():
    des_type = 'HOG'
    
    # If feature directories don't exist, create them
    if not os.path.isdir(pos_feat_ph):
        os.makedirs(pos_feat_ph)

    # If feature directories don't exist, create them
    if not os.path.isdir(neg_feat_ph):
        os.makedirs(neg_feat_ph)

    print "Calculating the descriptors for the positive samples and saving them"
    for im_path in glob.glob(os.path.join(pos_im_path, "*")):
        #print im_path
        
##        im = imread(im_path, as_grey=True)
        
        sobel_img = imread(im_path, as_grey=True)
        dx = ndimage.sobel(sobel_img, 1)
        dy = ndimage.sobel(sobel_img, 0)
        mag = np.hypot(dx, dy)
        mag *= 255.0 / np.max(mag)
        im = ndimage.sobel(mag, 0)
        
        if des_type == "HOG":
            fd = hog(im, orientations, pixels_per_cell, cells_per_block, visualize, normalize)
        fd_name = os.path.split(im_path)[1].split(".")[0] + ".txt"
        fd_path = os.path.join(pos_feat_ph, fd_name)
##        np.savetxt(fd_path, fd,'%.10f')
        np.savetxt(fd_path, fd)
##        joblib.dump(fd, fd_path)
    print "Positive features saved in {}".format(pos_feat_ph)

    print "Calculating the descriptors for the negative samples and saving them"
    for im_path in glob.glob(os.path.join(neg_im_path, "*")):
        
##        im = imread(im_path, as_grey=True)

        sobel_img = imread(im_path, as_grey=True)
        dx = ndimage.sobel(sobel_img, 1)
        dy = ndimage.sobel(sobel_img, 0)
        mag = np.hypot(dx, dy)
        mag *= 255.0 / np.max(mag)
        im = ndimage.sobel(mag, 0)
        
        if des_type == "HOG":
            fd = hog(im,  orientations, pixels_per_cell, cells_per_block, visualize, normalize)
        fd_name = os.path.split(im_path)[1].split(".")[0] + ".txt"
        fd_path = os.path.join(neg_feat_ph, fd_name)
##        np.savetxt(fd_path, fd,'%.10f')
        np.savetxt(fd_path, fd)
##        joblib.dump(fd, fd_path)
    print "Negative features saved in {}".format(neg_feat_ph)

    print "Completed calculating features from training images"

if __name__=='__main__':
    extract_features()
